; JFW 3.31 Script file for Microsoft Access 97 and 2000
; Copyright 1998-99 by Henter-Joyce, Inc.
; Written by Joseph K Stephen (formerly Dunn).
; build ac3312150 last modified 15 September 1999
; This file contains support for Access 97 and 2000 only.
; see access95.jss for support for earlier versions of Microsoft Access.

include "accessal.jsh" ; constants and globals for all versions of Microsoft Access
include "msaccess.jsh" ; constants and globals for Microsoft Access 97 and 2000 only
include "accessal.jsm" ; messages for all versions of Microsoft Access
include "msaccess.jsm" ; messages for Microsoft Access 97 and 2000 only
include "hjconst.jsh"
include "hjglobal.jsh"
use "magAccs.jsb"

Function AutoStartEvent ()
if GetProgramVersion (GetAppFilePath ()) < 8 then
	switchToScriptFile(access95Scripts, defaultScripts)
	return ; not needed, here for clarity
endIf
let OAccess = MSOGetMenuBarObject ();
let oAccess = oAccess.Application ; init pointer to access app object
if !oAccess then
	let oAccess = GetObject ("Access.Application") ;
EndIf
let labelSearch=true
let globalPriorSubformName="" ; initialise
if (HasRunBefore == false) then
	let HasRunBefore = true
	if (GetVerbosity() == beginner) then
		SayExtendedHelpHotKey ()
		Say (msg1, OT_HELP) ;"Use Insert plus the letter H for help in various dialog boxes"
	EndIf
EndIf
EndFunction

Script SayAccessVersion ()
if GetProgramVersion (GetAppFilePath ()) ==8 then
	Say (msg475, OT_MESSAGE) ; "Access 97"
else
	say(msg476,ot_message) ; Access 2000
endIf
EndScript

Script ReadDataSheetCoordinates ()
var
	object sheet,
	int row,
	int col
let sheet =OAccess.screen.activeDatasheet()
if sheet then
  let col=sheet.selLeft()
  let row=sheet.selTop()
  Say (msg477, OT_MESSAGE) ; " col "
  sayInteger(col)
  say (msg478, OT_MESSAGE) ; "row "
  sayInteger(row)
EndIf
EndScript

Script SayStatusLine ()
var
   HANDLE hWnd
let hWnd = GetAppMainWindow(GetFocus())
let hWnd = GetFirstChild(hWnd)
while (hWnd)
;wc112="ostatbar"
	if (GetWindowClass(hWnd) == wc112) then
		SayWindow(hWnd,0)
		return
	EndIf
	let hWnd = GetNextWindow(hWnd)
endWhile
EndScript

Int Function ControlIsDetachedLabel (object form, object label)
; this function is used to determine which labels on a form
; are not associated with other controls but just
; provide descriptive or helpful information
var
int index,
int result,
string compare
let result=true ; set to false is we know for sure that a label is associated with a control
 
let compare=label.name
; check known labels
; hardcoded in GetControlLabel
; only relevant in wizard screens
if InWizard then
  if stringsEqual(compare,msg499) || ; "text517"
  stringsEqual(compare,msg501) ||; "text531"
  stringsEqual(compare,msg503) || ; "LblRelTbl" 
  stringsEqual(compare,msg507a) || ; "lblfr0" 
  stringsEqual(compare,msg507c) || ; "lblfr8" 
  stringsEqual(compare,msg507e) || ; "lblfr6" 
  stringsEqual(compare,msg507w) || ; "Text150" 
  stringsEqual(compare,msg507g) || ; "Text162" 
  stringsEqual(compare,msg507i) || ; "text164" 
  stringsEqual(compare,msg507k) || ; "text161" 
  stringsEqual(compare,msg507m) || ; "text507" 
  stringsEqual(compare,msg507n) || ; "Label179" 
  stringsEqual(compare,msg507z) || ; "Label1" 
  stringsEqual(compare,msg507t) || ; "lblStylePrompt" 
  stringsEqual(compare,msg507u) || ; "LblLstStyles" 
  stringContains(compare, msg507x) || ; msg507x= "lblRowHdr" 
  StringContains(compare, msg507y) then ; msg507y="lblColHdr"
  let result=false ; these are all asoc with known controls
  endIf
endIf
; this next test assumes:
; a label control whose parent's name contains the letters frm
; indicating form, is a detached label, otherwise the label's parent would point to a non form
; control.
;msg486 = "frm"
if result && StringContains(stringLower(label.parent.name()),msg486) then
  let result=true
; a label's parent property should always point to the control it is labelling
; so if it points to the parent form then it is detached. 
elif label.parent.name==form.name then
	let result=true
else
	let result=false
endIf
return result
EndFunction

Int Function inMacroProperties ()
var
int vertDistance
let VertDistance=GetWindowTop(GetParent(GetFocus()))-getWindowTop(GetRealWindow(getFocus()))
; only reliable way of determining if in properties panel of table design view
return VertDistance > 80
EndFunction

Int Function InTblProperties ()
var
int vertDistance
let VertDistance=GetWindowTop(GetParent(GetFocus()))-getWindowTop(GetRealWindow(getFocus()))
; only reliable way of determining if in properties panel of table design view
return VertDistance > 100
EndFunction

Void Function SayDesignViewControl ()
var
	Handle Parent,
	string class,
	int Left,
	int Right,
handle focus
let focus=GetFocus()
let Parent= GetParent(Focus)
let class = GetWindowClass (parent)
; wc220="#32770" 
if Class==wc220 then
; in a dialog
  SayObjectTypeAndText()
  return
EndIf
; all dialogs with class OArgDlg,
; must be before next tests (ie Tbl and qry design grid)
; wc115="OArgDlg" 
if GetWindowClass(GetParent(parent))==wc115 then
  SaveCursor()
  RouteInvisibleToPc()
  invisibleCursor()
  let right=getCursorCol()
  JawsHome()
  let left=GetCursorCol()
  SayTextBetween(left,right)
  let GlobalControlLabel=GetTextBetween(left,right)
  RestoreCursor()
; wc121="OScript"
elif GetWindowClass(GetRealWindow(Focus))==wc121 then
  if inMacroProperties() then
    SaveCursor()
    RouteInvisibleToPc()
    invisibleCursor()
    PriorChunk()
    SayChunk()
    let GlobalControlLabel=GetChunk()
    RestoreCursor()
  else
; in top part of macro design view
    if not SuppressColumnTitle then
      SaveCursor()
    InvisibleCursor()
    let Left = GetWindowLeft(Focus)
    	let Right = GetWindowRight(Focus)
    	MoveToWindow(Parent)
    	SayTextBetween(Left,Right)
      let GlobalControlLabel=GetTextBetween(left,right)
      let SuppressColumnTitle=true ; have spoken it
      RestoreCursor()
    EndIf
  endIf
elif TableDesignView then
; determine if in properties panel
  if InTblProperties() then ; must also be in table design view.
    SaveCursor()
    RouteInvisibleToPc()
    invisibleCursor()
    PriorChunk()
    SayChunk()
    let GlobalControlLabel=GetChunk()
    RestoreCursor()
   ;wc117="OGrid"
  elif (class == wc117) then
; in top part of table design view
    if not SuppressColumnTitle then
      SaveCursor()
    InvisibleCursor()
    let Left = GetWindowLeft(Focus)
    	let Right = GetWindowRight(Focus)
    	MoveToWindow(Parent)
    	SayTextBetween(Left,Right)
      let GlobalControlLabel=GetTextBetween(left,right)
      let SuppressColumnTitle=true ; have spoken it
      RestoreCursor()
    EndIf
  endIf
elif (QryDesignView && inDesignGrid) then
  if not suppressRowTitle then
    SaveCursor()
    RouteInvisibleToPc()
    InvisibleCursor()
    JawsHome()
    Sayword()
    let GlobalControlLabel=GetWord()
    let suppressRowTitle=true ; have spoken it
    restoreCursor()
  EndIf
endIf
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	HANDLE RealWindow,
	string RealWindowName,
	HANDLE AppWindow
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
let FocusChangedCalled=1 ; J Dunn, used by tabKey and shiftTabKey
if (StringContains (GetWindowClass (RealWindow), wc113)) then
; we are in an SDM dialog
let GlobalRealWindow = RealWindow
let GlobalRealWindowName = RealWindowName
let GlobalFocusWindow = FocusWindow
SaySDMFocusedWindow()
Else ; not sdm
;start of regular non-sdm logic
if (GlobalPrevApp != AppWindow
&& AppWindow != FocusWindow) then
; we've switched to a different app main window,
; and it does not have the focus, so announce it
SayWindowTypeAndText(appWindow)
EndIf

If ((GlobalPrevRealName != RealWindowName) ; name has changed
|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
   If ((RealWindow != AppWindow)
  && (RealWindow != FocusWindow)) then
			SayWindowTypeAndText(RealWindow)
  endIf
endIf
; now say the window with focus
let GlobalFocusWindow = FocusWindow ; to access it from another routine
SayFocusedWindow () ; will use global variable GlobalFocusWindow
endIf ; end non sdm
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Function SayFocusedWindow ()
; called by focus changed, to say the control with focus
var
	string RealClass, ; real window class
	string TheClass, ; focus class
	string GrandParentClass, ; grandparent of global focus window
	string GreatGrandparentClass,
	string RealWindowName,
	handle RealWindow,
int TheControlId 

if MenusActive() then
  SayFocusedObject()
  return
endIf
let RealWindow=GetRealWindow(GlobalFocusWindow)
let RealWindowName=GetWindowName(RealWindow)
let RealClass=GetWindowClass(RealWindow)
let TheClass=GetWindowClass(GlobalFocusWindow)
let theControlId=getControlId(globalFocusWindow)
; wn114 = spell checker
if RealWindowName==wn114 && 
	theControlId==SpellChangeToEditId then
	performScript spellCheck()
	let InSpellChecker=true
	return
else
	let inSpellChecker=false
endIf

;wn115 = "Wizard"
if StringContains(realWindowName, wn115) then
; next variable used in getControlLabel and  controlIsDetachedLabel  
	let InWizard=true
else
	let InWizard=false
endIf
;wc107="toolbarWindow32" 
; the toolbars in the Access 2000 database window
if theClass==wc107 then
; say toolbar button
	sayLine()
	return
endIf

if RealClass== wc115 || ; wc115="OArgDlg" in multipage dialog
	 RealClass==wc121 ; in macro dlg
	then
	SayDesignViewControl()
	sayObjectTypeAndText()
	return
endIf

; wc118="OForm"
; could be oForm or oFormSub or oFormPopup 
if StringContains(RealClass,  wc118) then
	performScript SayFocusedControl()
	return
endIf

; wc110="oSysRel"
let GreatGrandparentClass=GetWindowClass(GetParent(GetParent(GetParent(globalFocusWindow))))
if greatGrandparentClass==wc110 then
	speakRelationship()
	return
endIf

;wc122="OQry",
let GrandparentClass=GetWindowClass(GetParent(GetParent(globalFocusWindow)))
if (GrandParentClass==wc122 ||
	GreatGrandparentClass==wc122)
	&& isDesignView() then
; query design view
	let QryDesignView=true
	let TableDesignView=false
;wc116="OKttbx",
	if TheClass==wc116 then
	; in design grid
		let inDesignGrid=true
	else
		let InDesignGrid=false
	endIf
	sayDesignViewControl()
	sayObjectTypeAndText()
	return
endIf

; wc120 ="OTable"
if realClass==wc120 then
; table, which view are we in?
	if isDesignView() then
	; table design view
		let TableDesignView=true
		let QryDesignView=false
		sayDesignViewControl()
	else
	; in a table data entry screen
		if not SuppressColumnTitle then
	; say the datasheet field
			say (OAccess.Screen.ActiveControl.Name(), OT_STRING)
			let GlobalControl=OAccess.screen.activeControl()
			let suppressColumnTitle=true ; have spoken it.
		endIf
	endIf
SayObjectTypeAndText()
; must return here or tableDesignView variable will be unintentionally reset
	return 
endIf
SayObjectTypeAndText()
; if got here, need to reset variables
let TableDesignView=false
let QryDesignView=false
let InDesignGrid=false
let globalPriorSubformName="" ; initialise
EndFunction

Function SaySDMFocusedWindow ()
let GlobalCurrentControl = SdmGetFocus (GlobalFocusWindow)
; If we've just entered a new real window say it
If (GlobalPrevReal != GlobalRealWindow)
|| GlobalRealWindowName != GlobalPrevRealName then
SayWindowTypeAndText (GlobalRealWindow) ; dialog box name
;SdmSayWindowTypeAndText (GlobalRealWindow, SdmGetFocus (GlobalRealWindow ))
SdmSayStaticText (GlobalRealWindow) ;dialog box text
EndIf ; new real window handle or name
; now say the current control
If (GlobalCurrentControl > 0) then
SdmSayWindowTypeAndText (GlobalFocusWindow, GlobalCurrentControl)
EndIf ; control id > 0
EndFunction

Script  SayWindowTitle()
var
	handle CurrentWindow,
	handle RealWindow,
	handle AppWindow
let CurrentWindow = GetCurrentWindow()
if (CurrentWindow > 0) then ; handle not 0
	let RealWindow = GetRealWindow (CurrentWindow)
	let AppWindow = GetAppMainWindow (CurrentWindow)
	if GetVerbosity() == beginner then
		Say (msg482, OT_MESSAGE)
	EndIf
	if (IsMultiPageDialog ()) then
	Say (GetWindowName (RealWindow), OT_WINDOW_NAME)
		Say (GetDialogPageName (), OT_DIALOG_NAME)
	return
	endIf
	If AppWindow != CurrentWindow then
		Say (GetWindowName (AppWindow), OT_APP_NAME)
	endif
	if StringContains (GetWindowClass (RealWindow), wc113) then ; this is an SDM dialog
		Say (GetWindowName (RealWindow), OT_DIALOG_NAME)
		SayObjectTypeAndText ()
		return
	EndIf
	If ((RealWindow != AppWindow)
	   && (RealWindow != CurrentWindow)) then
		Say (GetWindowName (RealWindow), OT_WINDOW_NAME)
	endif
	Say (GetWindowName (CurrentWindow), OT_WINDOW_NAME)
else
	ScreenSensitiveHelpForUnknownClasses()  ; when handle =0
endif
EndScript

Script SayWindowPromptAndText ()
; clear all suppressions
; so appropriate row/col title is spoken
let suppressColumnTitle=false
let suppressRowTitle=false
let globalPriorSubformName=""
SayFocusedWindow()
EndScript

Void Function databaseWindowHelp ()
var
string TheClass,
int theControlId

let theClass=getWindowClass(getFocus())
let TheControlId=getControlId(getFocus())
if getVerbosity()==beginner then
	say(msg171,ot_help)
endIf
Say (msg107, OT_HELP) ; database window
if theClass==wc107 then
; on the Access 2000 toolbars
	if theControlId==databaseObjectsToolbarId then
		say(msg100+msg100b,ot_help) ; db obj toolbar
		say(msg101,ot_help) ; use arrow keys etc.
		say(msg102,ot_help) ; you will then be focused on a listview ...			
		return
	elif theControlId==groupsToolbarId then
		say(msg100a+msg100b,ot_help) ; db obj toolbar
		say(msg101,ot_help) ; use arrow keys etc.
		say(msg102,ot_help) ; you will then be focused on a listview ...			
		return
	endIf
; listview in db window
else
	say (msg201+GetDialogPageName()+msg100b, OT_HELP) ; the xxx page has focus
	PerformScript ScreenSensitiveHelp () ; default script
endIf
EndFunction

Void Function wizardHelp ()
Say (msg171,ot_help)
say(OAccess.screen.activeForm.caption(), OT_BUFFER) ;"this is the xxx wizard"

say(msg172+getScriptKeyName("readFormInControlOrder"),ot_help) ; to read wizard help text use control+shift+w
say(msg151,ot_help) ; use tab and shift tab to move from control to control
say(msg172a,ot_help) ; "You may also use form hotkeys to select options directly." 
hotKeyHelpDefaultLoop()
EndFunction

Void Function tblDesignviewHelp ()
if getVerbosity()==beginner then
	say(msg171,ot_help) ; this is the
endIf
Say (msg171a, OT_HELP) ; table design view
Say (msg171b, OT_HELP)  ; "To switch between the definition and properties panels use f6.",
PerformScript ScreenSensitiveHelp () ; default script
EndFunction

Void Function qryDesignviewHelp ()
if getVerbosity()==beginner then
	say(msg171,ot_help) ; this is the
endIf
say (msg175, OT_HELP) ; query design screen
say (msg176, OT_HELP) ; "Press enter in the listbox to place the selected item on the grid.",
say (msg177, OT_HELP) ; "Use f6 to switch between the listboxes and the grid.",
Say (msg178, OT_HELP) ; "Use tab or shift+tab to go between the listboxes or between fields on the grid."
Say (msg242+msg154+GetScriptKeyName("CreateJoin")+msg154a, OT_HELP) ;
Say (msg240, OT_HELP) ; press again to ...
Say (msg228+msg154+getScriptKeyName("RelAndJoinClearValues")+msg154a, OT_HELP)
say (msg179, OT_HELP) ; "Ensure the application window is maximised so that field prompts are read in the grid."
PerformScript ScreenSensitiveHelp () ; default script
EndFunction

Void Function qryDatasheetOrSQLHelp ()
; if we get here we are assuming we are in a query view.
if GetVerbosity()==beginner then
	say(msg171,ot_help) ; this is the
endIf
if isDatasheetView() then
; we are in an open query otherwise known as datasheet view.
		say(msg179a,ot_help) ; this is the Query Datasheet View.
	say(msg179b+getWindowName(getRealWindow(GetFocus())),ot_help) ; it contains the results of the xxx query.
	say(msg179c,ot_help) ; use arrows and tab and shift tab to review the data
elif isSQLView() then
	say(msg179d,ot_help) ; this is the Query SQL View
	say(msg179e,ot_help) ; the edit field contains the SQL code.
	say(msg179f,ot_help) ; You may enter or edit the SQL code using the standard editing keys.
endIf
EndFunction

Void Function formHelp ()
if GetVerbosity()==beginner then
	say(msg171,ot_help) ; this is the
endIf
; check if in design view
if OAccess.Screen.activeForm.CurrentView==formDesignView then 
	Say (msg180a, OT_HELP)  ; "form Design View",
	Say (msg181, OT_HELP) ;  "Tab to the section you wish to select."
	Say (msg181a+msg154+GetScriptKeyName("SelectToolboxControl")+msg154a, OT_HELP)
	Say (msg182, OT_HELP) ;  You can also press Enter and a multiPage dialog will appear where you can set section properties.
	say (msg112, OT_HELP) ; "To set properties for a control, ensure that the format (form/report) toolbar is visible",
	Say (msg113, OT_HELP) ; "by selecting it in the View/Toolbars menu.",
	Say (msg114, OT_HELP) ; "Then, press alt to activate the menuBar and control+tab to the toolbars."
	Say (msg115, OT_HELP) ; "if there are more than one toolbars visible then you may have to press control+tab several times."
	Say (msg116, OT_HELP) ; "Once you have found the object combo on the format (form/report) toolbar, select the control whose properties you want to set.",
	Say (msg117, OT_HELP) ; "Finally, choose properties from the View Menu."
elif OAccess.Screen.activeForm.CurrentView==formFormView then
	Say (msg150, OT_HELP) ; Form View
	Say (msg151, OT_HELP) ; use tab and shift tab etc
	Say (msg152, OT_HELP) ; use f6 to switch panels
	Say (msg153, OT_HELP) ; use control f4 to close
elif OAccess.Screen.activeForm.CurrentView==formDatasheetView then
	say(msg153a,ot_help) ; form datasheet view.
	Say (msg151, OT_HELP) ; use tab and shift tab etc
	Say (msg153, OT_HELP) ; use control f4 to close

endIf
Say (msg155+msg154+GetScriptKeyName("ReadFormInControlOrder")+msg154a, OT_HELP)
Say (msg156+msg154+GetScriptKeyName("SelectFormControl")+msg154a, OT_HELP)
Say (msg167+msg154+GetScriptKeyName("ToggleLabelSearch")+msg154a, OT_HELP)
EndFunction

Void Function reportHelp ()
; determine if in design or preview mode
if isDesignView() then
; in report design view
	if getVerbosity()==beginner then
		say(msg171,ot_help) ; this is the
	endIf
	Say (msg180, OT_HELP)  ; "Report Design View",
	Say (msg181, OT_HELP) ;  "Tab to the section you wish to select.
	Say (msg181a+msg154+GetScriptKeyName("SelectToolboxcontrol")+msg154a, OT_HELP)
	Say (msg182, OT_HELP) ;  You can also press Enter and a multiPage dialog will appear where you can set section properties.
	say (msg112, OT_HELP) ; "To set properties for a control, ensure that the format (form/report) toolbar is visible",
	Say (msg113, OT_HELP) ; "by selecting it in the View/Toolbars menu.",
	Say (msg114, OT_HELP) ; "Then, press alt to activate the menuBar and control+tab to the toolbars."
	Say (msg115, OT_HELP) ; "if there are more than one toolbars visible then you may have to press control+tab several times."
	Say (msg116, OT_HELP) ; "Once you have found the object combo on the format (form/report) toolbar, select the control whose properties you want to set.",
	Say (msg117, OT_HELP) ; "Finally, choose properties from the View Menu."
else ; preview
	Say (msg158, OT_HELP) ; this is a report
	Say (msg159+msg154+GetScriptKeyName("ReadActiveReport")+msg154a, OT_HELP)
endIf
EndFunction

Void Function tblDatasheetHelp ()
var
string TblName
let tblName=oAccess.screen.activeControl.parent.name()
let tblName=tblName+msg519 ; append a space for clarity when reading or displaying on the Braille display 
if GetVerbosity()==beginner then
	say(msg171+tblName+msg171c,ot_help) ; this is the
else
say(tblName+msg171c,ot_help) ; table datasheet view
endIf
SpeakFieldInfo()
Say (msg219, OT_HELP) ; use tab and shift tab to move from field to field
say(msg160+msg154+getScriptKeyName("readDatasheetCoordinates"),ot_help) ; to hear datasheet coordinates
EndFunction

Void Function relationshipHelp ()
if GetVerbosity()==beginner then
	say(msg171,ot_help) ; this is the
endIf
Say (msg235, OT_HELP) ; "Relationships Window.",
say(msg235a,ot_help) ; it contains a listbox of fields for each table displayed
say(msg235b,ot_help) ; use tab etc.
Say (msg237+msg238, OT_HELP)
Say (msg236+msg154+GetScriptKeyName("CreateRelationship")+msg154a, OT_HELP)
Say (msg227, OT_HELP) ; "Press this key combination again once located in the destination table and on the destination field to create the relationship.",
Say (msg228+msg154+getScriptKeyName("relAndJoinClearValues")+msg154a, OT_HELP)
say (msg105+msg154+getScriptKeyName("deleteRelationship")+msg154a, OT_HELP) ; press control del to delete the selected relationship
PerformScript ScreenSensitiveHelp () ; default script
EndFunction

Script ScreenSensitiveHelp ()
var
	handle theFocus,
string RealClass 

if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
let theFocus = GetFocus()
let realClass=getWindowClass(GetRealWindow(theFocus))
if GlobalMenuMode == MENUBAR_ACTIVE then
	ScreenSensitiveHelpForKnownClasses (WT_COMMANDBAR)
	return
elif (GlobalMenuMode == MENU_ACTIVE) then
	ScreenSensitiveHelpForKnownClasses (wt_menu)
	return
EndIf
; wc111="ODb"
if realClass==wc111 then
	databaseWindowHelp()
	;wn115 = "Wizard"
elif stringContains(GetWindowName (getRealWindow(theFocus)), wn115)then
	wizardHelp()
elif TableDesignView then
	tblDesignviewHelp()
elif QryDesignView then
	qryDesignviewHelp()
; wc122="oQry"
elif RealClass==wc122 then
	qryDatasheetOrSQLHelp()
;wc118="OForm"
elif StringContains(realClass,wc118) then
	formHelp()
	;wc119="OReport"
	elif StringContains(realClass,wc119) then
	reportHelp()
	; wc120="OTable"
elif realClass==wc120 then
	tblDatasheetHelp()
	;wc110=OSysRel
elif GetWindowClass(GetParent(GetParent(GetParent(theFocus)))) == wc110 then
	relationshipHelp()
else
	PerformScript ScreenSensitiveHelp () ; default script
endIf
EndScript

Script ScriptFileName ()
if GetProgramVersion (GetAppFilePath ()) ==8 then
	ScriptAndAppNames (msg475)
else
	ScriptAndAppNames (msg476)
endIf
EndScript


Script SpellCheck ()
;wn114="Spelling:"
If (GetWindowName (GetRealWindow(GetCurrentWindow())) == wn114) Then
RouteInvisibleToPc()
InvisibleCursor()
JawsPageUp()
NextLine()
JawsEnd()
If (GetVerbosity () > 0) then
SayWord ()
Else
SayLine ()
EndIf
SpellWord() ;spell it either way
NextLine()
JawsEnd ()
If (GetVerbosity () > 0) then
SayWord ()
Else
SayLine()
EndIf
SpellWord() ;spell it either way
PcCursor()
Else
Say (msg128, OT_MESSAGE) ;"Not in spell checker"
EndIf
EndScript

Void Function SayHighlightedText (handle CurrentWindow, string buffer)
var
string theClass
let theClass=getWindowClass(currentWindow)
; if the class is oFormChild, oKTTBX or oGrid then we will use the object model
; to speak an object's state, ie selected item etc.
; otherwise we often get double speaking or confusion as more than 
;one highlighted item is spoken in a wizard.
if theClass==wc114 ||
	theClass==wc116 ||
	 theClass==wc117 then
	return
endIf
if(GetScreenEcho() > ECHO_NONE) Then
Say (buffer, OT_BUFFER)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
string TheClass
let TheClass = GetWindowClass(hwnd)

if inSpellChecker then
	if getControlId(hwnd)==SpellMispelledWordId then
		performScript spellCheck()
	endIf
	return
endIf
;wn129="#32771"
;wc220 = "#32770"
;wc108=="msoUniStat"
if ((GetScreenEcho() > 1) ||
(TheClass == wn129 || theClass==wc220 || theClass==wc108)) then
Say (buffer, OT_BUFFER)
Return
EndIf
EndFunction

String Function stripHKMarker (string caption)
var
int markerPos,
int captionLength

; msg487="&"
let MarkerPos=stringContains(caption, msg487) 
let captionLength=stringLength(caption)
if markerPos then
	return subString(caption,1,markerpos-1)+substring(caption,markerPos+1,captionLength)
else
	return caption
endIf
EndFunction

Int Function IsDesignView ()
var
	object menuBar

let menuBar=MSOGetMenuBarObject ()
return Menubar.controls(MnuView).controls(OptDesignView).state()
EndFunction

Void Function IsSQLView ()
var
	object menuBar

let menuBar=MSOGetMenuBarObject ()
return Menubar.controls(MnuView).controls(OptSQLView).state()
EndFunction

Void Function IsDatasheetView ()
var
	object menuBar

let menuBar=MSOGetMenuBarObject ()
return Menubar.controls(MnuView).controls(OptDatasheetView).state()
EndFunction

String Function GetDialogPageName ()
var
	object menuBar,
	object ViewDbObjMenu,
	string PageName,
	int count,
	int HotKeyIndex,
	int StrLen,
	int index
; wc111="ODb"
if GetWindowClass(GetRealWindow(GetFocus()))==wc111 then
  let menuBar=MSOGetMenuBarObject ()
  let viewDbObjMenu=Menubar.controls(MnuView).controls(MnuDbObj).controls()
  let count=ViewDbObjMenu.count()
let index=1
  while index <= count
    if ViewDbObjMenu(index).state then
    ; item checked
      let PageName=ViewDbObjMenu(index).caption()
      let index=count
    endIf
    let index=index+1
  endWhile
  let PageName=stripHKMarker(PageName)
  let PageName=PageName+msg488
else
 ; call default built-in function
  let PageName=GetDialogPageName()
endIf
return PageName
EndFunction

Void Function IsMultiPageDialog ()
var
	handle WinHandle

if GetWindowclass(GetFocus())==wc111 then
	return true ; database window is a multipage dialog
endIf
let WinHandle = GetCurrentWindow ()
let WinHandle = GetRealWindow (WinHandle)
let WinHandle = GetFirstChild (WinHandle)
while (WinHandle)
	if (GetWindowTypeCode (WinHandle) == wt_TabControl) then
		return true
	EndIf
	let WinHandle = GetNextWindow (WinHandle)
EndWhile
return false
EndFunction

String Function GetControlTypeAndState (object control, int InOptionGroup)
; avoid error if control's parent is a form and attempt to look at ControlType property
; by passing InOptionGroup as int parameter,
; set to true if called from ReadOptionGroupActiveItem,
; set to false if called elseware.
var
	int type,
	int index,
	int UBound,
	string name,
	string CtlState ; used for checkboxes etc
let type =control.controlType()
let name=""
let CtlState=""
if type==acLabel	then
  let name=TxtAcLabel
elif type==acRectangle then
  let name=TxtAcRectangle
elif type==acLine then
  let name=TxtAcLine
elif type==acImage then
  let name=TxtAcImage
  let CtlState=control.picture()
elif type==acCommandButton then
  let name=TxtAcCommandButton
elif type==acOptionButton then
  if InOptionGroup then
    if control.parent.Value==control.optionValue then
; msg496="Selected"
; msg497-"Not Selected"
      let CtlState=msg496
    else
      let CtlState=msg497
    EndIf
  else
    if control.value==1 then
      let CtlState=msg496
    else
      let CtlState=msg497
    EndIf
  EndIf
  let name=TxtAcOptionButton
elif type==acCheckBox then
  if InOptionGroup then
    if control.parent.value==control.optionValue then
      ;msg489 = "Checked"
      let CtlState=msg489
    else
      ;msg490 = "Unchecked"
      let CtlState=msg490
    EndIf
  else
    if control.value then
      ;msg489 = "Checked"
      let CtlState=msg489
    else
      ;msg490 = "Unchecked"
      let CtlState=msg490
    endIf
  endIf
  let name=TxtAcCheckBox
elif type==acOptionGroup then
  let name=TxtAcOptionGroup
elif type==acBoundObjectFrame then
  let name=TxtAcBoundobjectframe
elif type==acTextBox then
  let name=TxtAcTextBox
  let CtlState=control.text()
elif type==acListBox then
  let index=control.ListIndex+1
  let UBound=control.listCount
  if UBound then
; note had to use following lines to get listbox selection
; because itemData property was returning an integer rather than the data.
     ;msg491 = "lstSelFlds"
    if control.name==msg491 then
; this listbox is odd
      let ctlState=control.column(2,control.ListIndex)
    else
      let ctlState=control.column(1,control.ListIndex)
    endIf
   ;msg492 = " of "
   let ctlState=CtlState+intToString(index)+msg492+intToString(uBound)
  else
    ;msg493 = "zero items"
    let CtlState=msg493
  endIf
  let name=TxtAcListbox
elif type==acComboBox then
  let name=TxtAcCombobox
  let ctlState=control.text()
elif type==acSubform then
  let name=TxtAcSubform
elif type==acObjectFrame then
  let name=TxtAcobjectframe
elif type==acPageBreak then
  let name=TxtAcPageBreak
elif type==acPage then
  let name=TxtAcPage
elif type==acCustomControl then
  let name=TxtAcCustomControl
elif type==acToggleButton then
  if InOptionGroup then
    if control.parent.value==control.OptionValue then
      ;msg494 = "Pressed"
      let CtlState=msg494
    else
      ;msg495 = "Depressed"
      let CtlState=msg495
    endIf
  else
    if control.value then
      ;msg494 = "Pressed"
      let CtlState=msg494
    else
      ;msg495 = "Depressed"
      let CtlState=msg495
    EndIf
  endIf
  let name=TxtAcTogglebutton
elif type==acTabCtl then
  let name=TxtAcTabCtl
endif
if control.enabled==false then
	let ctlState=ctlState+msg518 ; disabled.
endIf
let name=name+" "+ctlState
return name
EndFunction

String Function GetControlState (object control, int InOptionGroup)
var
int type,
int index,
int UBound,
string CtlState ; used for checkboxes etc

let type =control.controlType()
let CtlState=""
if type==acOptionButton then
  if InOptionGroup then
    if control.parent.value==control.OptionValue then
      ;msg496 = "Selected"
      let CtlState=msg496
    else
      ;msg497 = "Not selected"
      let CtlState=msg497
    endIf
  else
    if control.value then
      ;msg496 = "Selected"
      let CtlState=msg496
    else
      ;msg497 = "Not selected"
      let CtlState=msg497
    EndIf
  endIf
elif type==acCheckBox then
  if InOptionGroup then
    if control.parent.value==control.OptionValue then
      ;msg489 = "Checked"
      let CtlState=msg489
    else
      ;msg490 =  "Unchecked"
      let CtlState=msg490
    endIf
  else
    if control.value then
      ;msg489 = "Checked"
      let CtlState=msg489
    else
      ;msg490 = "Unchecked"
      let CtlState=msg490
    endIf
  EndIf
elif type==acTextBox then
  let CtlState=control.text()
elif type==acListBox then
  let index=control.ListIndex+1
  let UBound=control.listCount
  if UBound then
; note had to use following lines to get listbox selection
; because itemData property was returning an integer rather than the data.
     ;msg491 = "lstSelFlds"
    if control.name==msg491 then
; this listbox is odd
      let ctlState=control.column(2,control.ListIndex)
    else
      let ctlState=control.column(1,control.ListIndex)
    endIf
   ;msg492 = " of "
   let ctlState=CtlState+intToString(index)+msg492+intToString(uBound)
  else
    ;msg493 = "zero item
    let CtlState=msg493
  endIf
elif type==acComboBox then
  let CtlState=control.text()
elif type==acToggleButton then
  if InOptionGroup then
    if control.parent.value==control.OptionValue then
      ;msg494 = "Pressed"
      let CtlState=msg494
    else
      ;msg495 = "Depressed"
      let CtlState=msg495
    endIf
  else
    if control.value then
      ;msg494 = "Pressed"
      let CtlState=msg494
    else
      ;msg495 = "Depressed"
      let CtlState=msg495
    EndIf
  EndIf
elif type==acCommandButton then
  let ctlState=control.caption()
endif
if control.enabled ==false then
	let ctlState=ctlState+msg518 ; disabled.
endIf
return CtlState
EndFunction

String Function GetBrlControlTypeAndState (object control, int InOptionGroup)
var
	int type,
	int index,
	int UBound,
	string name,
	string CtlState ; used for checkboxes etc
let type =control.controlType()
let name=""
let CtlState=""
if type==acLabel	then
  let name=BrlAcLabel
elif type==acRectangle then
  let name=BrlAcRectangle
elif type==acLine then
  let name=BrlAcLine
elif type==acImage then
  let name=BrlAcImage
  let CtlState=control.picture()
elif type==acCommandButton then
  let name=BrlAcCommandButton
elif type==acOptionButton then
  if InOptionGroup then
    if control.parent.value==control.OptionValue then
      let CtlState=BrlChecked
    else
      let CtlState=BrlUnchecked
    endIf
  else
    if control.value then
      let CtlState=BrlChecked
    else
      let CtlState=BrlUnchecked
    EndIf
  endIf
  let name=BrlAcOptionButton
elif type==acCheckBox then
  if InOptionGroup then
    if control.parent.value==control.OptionValue then
      let CtlState=BrlChecked
    else
      let CtlState=BrlUnchecked
    EndIf
  else
    if control.value then
      let CtlState=BrlChecked
    else
      let CtlState=BrlUnchecked
    endIf
  EndIf
  let name=BrlAcCheckBox
elif type==acOptionGroup then
  let name=BrlAcOptionGroup
elif type==acBoundObjectFrame then
  let name=BrlAcBoundobjectframe
elif type==acTextBox then
  let name=BrlAcTextBox
elif type==acListBox then
  let index=control.ListIndex+1
  let UBound=control.listCount
  if UBound then
; note add actual item selected in BrailleBuildAcFocus function
   ;msg492 = " of "
   let ctlState=intToString(index)+msg492+intToString(uBound)
  else
    ;msg493 = "zero items"
    let CtlState=msg493
  endIf
  let name=BrlAcListbox
elif type==acComboBox then
  let name=BrlAcCombobox
elif type==acSubform then
  let name=BrlAcSubform
elif type==acObjectFrame then
  let name=BrlAcobjectframe
elif type==acPageBreak then
  let name=BrlAcPageBreak
elif type==acPage then
  let name=BrlAcPage
elif type==acCustomControl then
  let name=BrlAcCustomControl
elif type==acToggleButton then
  if InOptionGroup then
    if control.parent.value==control.OptionValue then
      let CtlState=BrlChecked
    else
      let CtlState=BrlUnchecked
    endIf
  else
    if control.value then
      let CtlState=BrlChecked
    else
      let CtlState=BrlUnchecked
    EndIf
  EndIf
  let name=BrlAcTogglebutton
elif type==acTabCtl then
  let name=BrlAcTabCtl
endif
if control.enabled ==false then
	let ctlState=ctlState+msg518 ; disabled.
endIf
let name=CtlState+" "+name ; reverse of speech version
return name
EndFunction

Script ToggleLabelSearch ()
if LabelSearch then
  Say (msg165, OT_STATUS) ; search off
  let LabelSearch=false
else
  Say (msg166, OT_STATUS) ; search on
  let LabelSearch=true
endIf
EndScript

Int Function stringsEqual (string str1, string str2)
if stringLength(str1) == stringLength(str2) then
	if str1==str2 then
		return true
	endIf
endIf
return false
EndFunction

String Function GetControlLabel (object form, object control)
var
string hotKey,
int HotKeyPos,
string ControlLabel, ; try and determine
string ControlName, ; internal name used by programmer
string namePrefix, ; grp, cbo, txt, etc, will eliminate common prefixes for sake of verbosity
object parentControl,
object thisControl,
int count,
int index

if InWizard then
; table wizard controls
  ;msg506 = "TbTableName"
  if control.name==msg506 then
    ;msg499 = "text517"
    let ControlLabel=form.controls(msg499).caption()
  ;msg500 = "GrpPk"
  elif control.name==msg500 then
    ;msg501 = "text531"
    let ControlLabel=form.controls(msg501).caption()
  ;msg502 = "GrpRelType"
  elif control.name==msg502 then
    ;msg503 = "LblRelTbl"
    let ControlLabel=form.controls(msg503).caption()
  ;msg504 = "GrpFinishView"
  elif Control.name==msg504 then
; msg507z="label1"
    let ControlLabel=form.controls(msg507z).caption()
; Simple query wizard controls
  ;msg505 = "GrpQrySummarize"
  elif control.name==msg505 then
      ;msg507n = "Label179"
    let ControlLabel=form.controls(msg507n).caption()
  ;msg507 = "TbPane0"
  elif control.name==msg507 then
; msg507a="lblfr0"
    let controlLabel=form.controls(msg507a).caption
; msg507b="GrpOpenMode" 
  elif control.name==msg507b then
; msg507c="lblfr8"
    let controlLabel=form.controls(msg507c).caption()
; msg507d="CBHelpCard"
  elif control.name==msg507d then
; msg507e="lblfr6"
    let controlLabel=form.controls(msg507e).caption()
; crosstab query wizard controls
;msg507f="LstRecSrcs"
  elif control.name==msg507f then
; msg507g="Text162"
    let ControlLabel=form.parent.controls(msg507g).caption()
; msg507h="LstColHdrs" 
  elif control.Name==msg507h then
;msg507i="text164"
    let ControlLabel=form.controls(msg507i).caption()
;msg507j="TbQryName" 
  elif Control.Name==msg507j then
;msg507k="text161"
    let ControlLabel=form.controls(msg507k).caption()
;msg507l="OgOpenMode"
  elif control.Name==msg507l then
; msg507m="text507"
    let ControlLabel=form.controls(msg507m).caption()
; report wizard
;msg507p="cboSortExpr"
  elif stringContains(control.name,msg507p) then
    let controlLabel=IntToString(StringToInt(subString(control.name,StringLength(control.name),1))+1)
;msg507q="btnSortDesc"
  elif StringContains(control.name,msg507q) then
    let controlLabel=IntToString(StringToInt(subString(control.name,StringLength(control.name),1))+1)
;msg507r="LstStyles"
  elif control.name==msg507r then
;msg507s="Frui_FrmPageStyles"
  if form.parent.name==msg507s then
; report wizard style list
;msg507t="lblStylePrompt"
      let ControlLabel=form.parent.controls(msg507t).caption()
  else
; database wizard style list for print and screen
;msg507u="LblLstStyles"
    let ControlLabel=form.parent.controls(msg507u).caption()
  EndIf
; form wizard controls
; msg507v="grpPaneContent0" 
    elif control.name==msg507v then
;msg507o="layout"
      let controlLabel=msg507o ; layout
  endIf
  EndIf
  if controlLabel !="" then
; check for hotkey
    ;msg487 = "&"
    let HotKeyPos=stringContains(ControlLabel,msg487)
    if HotKeyPos then ; has a shortcut or hot key
      let HotKey=substring(ControlLabel,hotKeyPos+1,1)
      let ControlLabel=substring(ControlLabel,1,hotkeypos-1)+substring(ControlLabel,hotkeypos+1, stringlength(ControlLabel)-hotkeypos)
      let ControlLabel=controlLabel+msg508+hotKey
    EndIf
    return ControlLabel
; note that LstStyles is also a control in the Database Wizard
; but since it would be used less than the report wizard,
; it is not hardwired due to complexity to discern the difference.
endIf

let ControlName=Control.name()
if control.caption != "" then
  let ControlLabel=Control.caption()
elif control.controlTipText != "" then
  let ControlLabel=Control.ControlTipText()
else
  if not LabelSearch then
    return ControlName
  endIf

; try and guess using a known method
; if the control is a label then its parent property should point to the control it labels
  let count=form.controls.count()
  let index=0
	while index < count
		let thisControl=form.controls(index)
		if thisControl.controlType==acLabel then ; it is a label
			let parentControl=thisControl.parent
			if stringsEqual(parentControl.name,control.name) then
; the parent of this label control is the control passed as a parameter
; whose label we are looking for
; we now have two choices, use the label.caption or the label.name
; both can sometimes be wrong.
; Caption should be the one we use though
				let controlLabel=thisControl.caption
				let index=count
			endif
		endif
		let index=index+1
	endWhile
  EndIf
if ControlLabel!="" then
  ;msg487 = "&"
  let HotKeyPos=stringContains(ControlLabel,msg487)
  if HotKeyPos then ; has a shortcut or hot key
    let HotKey=substring(ControlLabel,hotKeyPos+1,1)
    let ControlLabel=stripHKMarker(ControlLabel)
    ;msg508 = " Alt+"
    let ControlLabel=controlLabel+msg508+hotKey
  EndIf
  return controlLabel
else
	let namePrefix=stringLeft(control.name,3)
if stringContains(common3CharPrefixes,namePrefix) then
		return substring(control.name,4,stringLength(control.name))
else
	  return ControlName
	endIf
endIf
EndFunction

Void Function ReadOptionGroupActiveItem (object gb)
var
object control,
int index,
int count,
string state,
string tmpLbl
let count=gb.controls.count()
; initialize globalOptionGroup to name and type
let GlobalOptionGroup=GetControlLabel(gb.parent, gb)+" "+BrlAcOptionGroup+" "
let index=0
while index < count
  let Control=gb.controls(index)
  if control.controlType() !=acLabel && (control.OptionValue==gb.Value) then
; only want to announce the selected radio button or checked checkbox.
    let TmpLbl=GetControlLabel(gb, control)
    Say (TmpLbl, OT_STRING)
; build globalOptionGroup
    let GlobalOptionGroup=GlobalOptionGroup+TmpLbl
    say (GetControlTypeAndState(control, true), OT_STRING)
    let state=GetBrlControlTypeAndState(control, true)
    let globalOptionGroup=GlobalOptionGroup+" "+state+" "
    pause()
  endIf
  let index=index+1
endWhile
EndFunction

Void Function SayActiveItem ()
var
object form,
object control,
string label

let Control=oAccess.screen.activeControl  ; control with focus
; allows correct labels to be found when on a subform
let form=control.parent()
if !form then
	return
endIf
; next three lines set up globals for Braille tracking to
; save sluggish recalculation
let GlobalBrlCtlInfo=GetBrlControlTypeAndState(control, false)
let GlobalControl=control
; saying a local variable is faster than saying a global variable here.
say (GetControlState(control, false), OT_STRING)
; if control is a groupbox then read and Braille it as it cannot receive focus using tab key
if control.ControlType==AcOptionGroup then
	readOptionGroupActiveItem(control)
endIf
; ensure Braille is up-to-date, sometimes lags
BrailleRefresh()
EndFunction

Script SayFocusedControl ()
var
object form,
object control,
string label,
string subFormLabel 


let Control=oAccess.screen.activeControl  ; control with focus
; allows correct labels to be found when on a subform
let form=control.parent()
if form then
; check if it is a subform and get the subform's label
if form.parent.form then
	if form.form then
; we are on a subform, get its name and report it if it is the first time we've landed on it.
		let subFormLabel=form.caption
			if form.name!=globalPriorSubformName then
			let label=txtAcSubform+subformLabel+msg519a+msg519
		endIf
		let globalPriorSubformName=form.name
	endIf
endIf
; next three lines set up globals for Braille tracking to
; save sluggish recalculation
let Label=label+GetControlLabel(form,control)
let GlobalControlLabel=label
let GlobalBrlCtlInfo=GetBrlControlTypeAndState(control, false)
let GlobalControl=control
; saying a local variable is faster than saying a global variable here.
say (Label, OT_BUFFER)
  say (GetControlTypeAndState(control, false), OT_STRING)
; if control is a groupbox then read and Braille it as it cannot receive focus using tab key
  if control.ControlType==AcOptionGroup then
    readOptionGroupActiveItem(control)
  endIf
; ensure Braille is uptodate, sometimes lags
  BrailleRefresh()
elif TableDesignView || qryDesignView then
  ; object model does not work here.
  SayDesignViewControl()
  sayObjectTypeAndText()
; check for report or form design view
; wc119="OReport"
elif isDesignView() &&
  (GetWindowClass(GetFocus())==wc119 ||
  GetWindowClass(GetFocus())==wc118) then
  ; can tab from report header, to details to footer
; in report design view or to the details option in form design view.
; ensure JFW reads highlighted text.
  SetJcfOption(Opt_Screen_Echo, Read_Highlighted)
else ; say active control on focused object.
  if not SuppressColumnTitle then
    say(OAccess.Screen.ActiveControl.Name(), ot_string)
    let GlobalControl=OAccess.screen.activeControl()
; need to suppress column titles when arrowing up and down in table datasheet view.
    let suppressColumnTitle=true ; have spoken it.
  endIf
  sayObjectTypeAndText()
endIf
EndScript

Void Function ReadSubSubForm (object Subform)
var
object control,
int index,
int count
let count=subForm.controls.count()
let index=0
while index < count
	let Control=subForm.controls(index)
	if control.visible then
		if control.ControlType==AcOptionGroup then
			Say (GetControlLabel(SubForm, control), OT_BUFFER)
			say (GetControlTypeAndState(control, false), OT_STRING)
			ReadOptionGroupActiveItem(control)
			let index=index+control.controls.count()
		elif  control.controlType==acLabel then
			if controlIsDetachedLabel(subform,control) then
				say(control.caption,ot_string)
			endIf
		elif	control.controlType() !=acLabel &&
			control.ControlType!=acRectangle &&
			Control.ControlType !=acImage &&
			control.controlType !=acLine then

			Say (GetControlLabel(SubForm, control), OT_CONTROL_NAME)
			say (GetControlTypeAndState(control, false), OT_STRING)
		endIf
	endIf
  let index=index+1
	pause()
endWhile
EndFunction

Void Function ReadSubForm (object subForm)
var
object control,
int index,
int count
let count=subForm.controls.count()
let index=0
while index < count
	let Control=subForm.controls(index)
	if control.visible then
		if control.ControlType==acSubForm then
			readSubSubForm(control)
		elif control.ControlType==AcOptionGroup then
			Say (GetControlLabel(SubForm, control), OT_CONTROL_NAME)
			say (GetControlTypeAndState(control, false), OT_MESSAGE)
			ReadOptionGroupActiveItem(control)
			let index=index+control.controls.count()
		elif  control.controlType==acLabel then
			if controlIsDetachedLabel(subform,control) then
				say(control.caption,ot_string)
			endIf
		elif control.controlType() !=acLabel &&
			control.ControlType!=acRectangle &&
			Control.ControlType !=acImage &&
			control.controlType !=acLine then
			Say (GetControlLabel(SubForm, control), OT_CONTROL_NAME)
			say (GetControlTypeAndState(control, false), OT_MESSAGE)
		endIf
	endIf
	let index=index+1
	pause()
endWhile
EndFunction

Script ReadFormInControlOrder ()
var
object form,
object control,
int index,
int count

let form=OAccess.screen.activeForm()
let count=form.controls.count()
Say (form.caption(), OT_STRING)
let index=0
while index < count
	let Control=form.controls(index)
	if control.visible then
		if control.controlType==acSubForm then
			ReadSubForm(control)
		elif control.ControlType==AcOptionGroup then
			Say (GetControlLabel(Form, control), OT_CONTROL_NAME)
			say (GetControlTypeAndState(control, false), OT_STRING)
			ReadOptionGroupActiveItem(control)
; skip over controls in optionGroup as they will be handled in readOptionGroupActiveItem 
		let index=index+control.controls.count()
		elif control.controlType==acLabel then
			if controlIsDetachedLabel(form,control) then
				say(control.caption,ot_string)
			endIf
		elif control.controlType != acLine &&
			control.controlType != acImage &&
			control.ControlType !=acRectangle &&
			Control.ControlType != AcLine then
			Say (GetControlLabel(form, control), OT_CONTROL_NAME)
			say (GetControlTypeAndState(control, false), OT_MESSAGE)
		endIf
	endIf
	let index=index+1
	pause()
endWhile
EndScript

Script ReadActiveReport ()
var
object report,
object control,
int index,
int count

let report=OAccess.screen.activeReport
say (report.caption(), OT_TEXT)

let count =report.controls.count
let index=0
while index < count
  let control=report.controls(index)
  if control.controlType==acSubForm && control.visible() then
    ReadSubForm(control)
  elif control.ControlType==AcOptionGroup then
    if control.visible() then
      Say (GetControlLabel(report, control), OT_CONTROL_NAME)
      say (GetControlTypeAndState(control, false), OT_STRING)
      ReadOptionGroupActiveItem(control)
    endIf
    let index=index+control.controls.count()
  elif control.visible() &&
    control.ControlType !=AcLabel &&
    control.ControlType !=AcLine &&
    control.ControlType != acRectangle &&
    control.ControlType != acImage then
    Say (GetControlLabel(report,control), OT_CONTROL_NAME)
Say (GetControlState(control, false), OT_STRING)
  EndIf
 pause()
  let index=index+1
EndWhile
EndScript

Void Function SelectSubformControl (object form)
var
object control,
int index,
int SelectedControlIndex,
int count,
string CtlList,
string CtlName
let count=form.controls.count()
if count==0 then
  Say (msg109, OT_MESSAGE) ; no controls on subform.
  return
endIf
let index=0
while Index < count
let control=form.controls(index)
  let CtlName=control.name()
  if control.caption !="" then
    let ctlName=ctlName+msg519+stripHKMarker(control.caption)+msg519
  endIf
; note still need to list invisible controls because of the indexing.
  if control.enabled==false || control.visible==false then
    let CtlName=CtlName+msg164 ; (disabled)
  EndIf
  let CtlList=ctlList+CtlName+msg517
  let index=index+1
   EndWhile
let ctlList=CtlList+ExitOption
let SelectedControlIndex=0
; avoid dlg appearing and disappearing without allowing selection
Say (msg110, OT_MESSAGE) ; choose x to exit
while not SelectedControlIndex
  pause()
let SelectedControlIndex=DlgSelectItemInList (CtlList, msg119, false)
endWhile
; check exit condition: ExitOption selected
if selectedControlIndex==(count+1) then
  return
  endIf
if SelectedControlIndex then
  let control=form.controls(SelectedControlIndex-1)
  if control.enabled then
  control.SetFocus()
  else
say(control.parent.name,ot_string)
say(form.name,ot_string)
;    Say (msg163, OT_MESSAGE) ; this control cannot receive the focus etc.
return
  EndIf
   Say (GetControlLabel(form, control), OT_CONTROL_NAME)
    say (GetControlTypeAndState(control, false), OT_STRING)
endIf
EndFunction

Script SelectFormControl ()
var
object form,
object control,
int index,
int selectedControlIndex,
int count,
string CtlList,
string CtlName
let form=OAccess.screen.activeForm()
if !form then
  say (msg170, OT_MESSAGE) ;"Not on a form.",
  return
endIf

let count=form.controls.count()
let index=0
while Index < count
let control=form.controls(index)
  let CtlName=control.name()
  if control.caption !="" then
    let ctlName=ctlName+msg519+stripHKMarker(control.caption)+msg519
  endIf
; note still need to list invisible controls because of the indexing.
  if control.enabled==false || control.visible==false then
    let CtlName=CtlName+msg164 ; (disabled)
  EndIf
  let CtlList=ctlList+CtlName+msg517
  let index=index+1
   EndWhile
let ctlList=stringLeft(ctlList, (stringLength(ctlList)-1))
let SelectedControlIndex=DlgSelectItemInList (CtlList, msg120, false)
if SelectedControlIndex then
  let control=form.controls(SelectedControlIndex-1)
  if control.enabled then
    if control.controlType==AcSubForm then ; allow selection from subform
      SelectSubformControl(control)
      return
    else
      control.SetFocus()
    endIf
  else ; not able to receive focus
    Say (msg163, OT_MESSAGE) ; this control cannot receive the focus etc.
  endIf
   Say (GetControlLabel(form, control), OT_CONTROL_NAME)
    say (GetControlTypeAndState(control,false), OT_STRING)
endIf
EndScript

Script TabKey ()
let FocusChangedCalled=0
let SuppressColumnTitle=false
{tab}
pause()
if focusChangedCalled==0  then
	performScript SayFocusedControl()
EndIf
EndScript

Script ShiftTabKey ()
let FocusChangedCalled=0
let SuppressColumnTitle=false
{shift+tab}
pause()
if FocusChangedCalled==0 then
	performScript sayFocusedControl()
EndIf
EndScript

Script EnterKey ()
; double clicks mouse on currently selected item in listbox
; in Query design view
; also works to click highlighted item in Report DesignView.
; then focuses on tabs in multipage dialog for the item just selected.
if QryDesignView && not InDesignGrid &&
  GetWindowClass(GetCurrentWindow())==wc109 then
  RouteJawsToPc() ; place mouse on selected item
  if GetVerbosity()==beginner then
    Say (msg173, OT_MESSAGE) ; "placing "
    SayChunk()
    Say (msg174, OT_MESSAGE)  ; "on grid"
  EndIf
  JAWSCursor()
  LeftMouseButton ()
  LeftMouseButton ()
  pause()
  PCCursor()
  let InDesignGrid=true
elif isDesignView() &&
  (GetWindowClass(GetFocus())==wc118 ||
  GetWindowClass(GetFocus())==wc119) then
; in report or form design view
  RouteJawsToPc()
  LeftMouseButton ()
  LeftMouseButton ()
  pause()
; locate cursor on format tab.
; must first ensure in the section dialog because there are two other format strings which could
; be located by the findString command
if FindString(GetFocus(), msg483, s_top, S_unrestricted) && ; "Section:"
  FindString(GetCurrentWindow(), msg484, s_top, s_restricted) then ; "Format"
  pause()
; wc105="SysTabControl32" 
    if GetWindowClass(GetCurrentWindow())==wc105 then
      RoutePcToJaws()
      PcCursor()
    else
      pcCursor()
      Say (msg183, OT_MESSAGE); "Unable to focus on tab control"
    EndIf
  EndIf
else
  {enter}
EndIf
EndScript

Void Function HotKeyHelpDefaultLoop ()
var
	handle WinHandle,
	String WinName,
	String RealClassName,
	String HelpPhrase,
	handle Hndl,
	int FoundHotKey,
	int SDMControlHandle,
object form,
object control,
object subForm,
object subControl,
int count,
int subCount,
int subIndex,
int index
Let FoundHotKey = false
Let hndl = GetRealWindow (GetFocus ())
Let WinName = GetWindowName (hndl)
Let RealClassName = GetWindowClass (hndl)
InvisibleCursor ()
if (StringContains (RealClassName, wc113)) then  ; THIS IS AN SDM WINDOW
	Let WinHandle = GetRealWindow (GetFocus ())
	Let SDMControlHandle=SDMGetFirstControl (WinHandle)
	While (SDMControlHandle)
		MoveToControl (WinHandle, SDMControlHandle)
		if (GetHotKey() != "") then
			if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
				Say (msg485, OT_HELP) ; "Hot keys are as follows"
			endif
			;wn289=" use alt  "
			Let HelpPhrase = GetChunk () + msg508a + GetHotKey()
			Say (HelpPhrase, OT_TEXT)
			let FoundHotKey = 1
		EndIf
		if (IsMultiPageDialog ()) then
			let WinHandle = GetCurrentWindow()
		endif
		let SDMControlHandle = SDMGetNextControl (WinHandle, SDMControlHandle)
	EndWhile
else ;Not SDM Window
	Let WinHandle = GetRealWindow (GetFocus ())
	Let WinHandle=GetFirstChild (WinHandle)
	While (WinHandle)
		If ((GetWindowSubtypeCode (WinHandle) == wt_button) ||
		   (GetWindowSubTypeCode (WinHandle) == wt_static)) then     ;condition for static text or button
			MoveToWindow (WinHandle)
			If hndl != GetRealWindow (GetCurrentWindow ()) then
				PCCursor ()
				return
			endif
			if (GetHotKey() != "") then
				if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
					Say (msg485, OT_HELP) ; "Hot keys are as follows"
				endif
				Let HelpPhrase = GetChunk () + msg508a + GetHotKey()
				Say (HelpPhrase, OT_TEXT)
				let FoundHotKey = 1
			endif
		EndIf ; condition for static text or button
		Let WinHandle=GetNextWindow (WinHandle)
	EndWhile
endif
PcCursor ()

; speak form hotkeys if they exist
if StringContains(RealClassName, wc118) then
	let form=oAccess.screen.activeForm()
	if form.currentView()==1 then
		let count=form.controls.count
		let index=0
		while index < count
			let control=form.controls(index)
			if control.ControlType==acSubForm then
				; look at subform hotkeys
				let subform=control
				let subIndex=0
				let SubCount=subform.controls.count()
				while subIndex < subcount
					let SubControl=Subform.controls(SubIndex)
					if subcontrol.visible then
						if stringContains(SubControl.caption,msg487) then; "&"
							if not FoundHotKey then
								say (msg162a, OT_HELP) ; subForm hot keys are as follows
							EndIf
							let FoundHotKey=true
							Say (GetControlLabel(subform, subControl), OT_STRING)
						EndIf
					endIf
					let subIndex=subIndex+1
				endWhile
				let foundHotKey=false
			endIf
			if control.visible then
				if stringContains(control.caption,msg487) then; "&"
					if not FoundHotKey then
						say (msg162, OT_HELP) ; Form hot keys are as follows
					EndIf
					let FoundHotKey=true
					Say (GetControlLabel(form, control), OT_TEXT)
				EndIf
			endIf
			let index=index+1
		EndWhile
	endIf
endIf
EndFunction

Script accessHotkeyHelp ()
var
	String RealClassName
Let RealClassName = GetWindowClass (getRealWindow(GetFocus()))
; wc119="oReport"
if StringContains(RealClassName, wc119) then
	if isDesignView() then
		Say (msg159+msg154+GetScriptKeyName("ReadActiveReport")+msg154a, OT_HELP)
		Say (msg181a+msg154+GetScriptKeyName("SelectToolboxControl")+msg154a, OT_HELP)
	else
		Say (msg159+msg154+GetScriptKeyName("ReadActiveReport")+msg154a, OT_HELP)
	endIf
; wc120="oTable"
elif realClassName==wc120 then
	if isDesignView() then
		Say (msg171b, OT_HELP)  ; "To switch between the definition and properties panels use f6.",
	else
			Say (msg185+msg154+getScriptKeyName("SpeakTableSummary")+msg154a, OT_HELP)
		say(msg160+msg154+getScriptKeyName("readDataSheetCoordinates")+msg154a,ot_help) ; to hear datasheet coordinates ...
	endIf
; wc110=OSysRel
elif GetWindowClass(GetParent(GetParent(GetParent(GetFocus())))) == wc110 then
	say (msg236+msg154+GetScriptKeyName("CreateRelationship")+msg154a, OT_HELP)
	Say (msg227, OT_HELP) ; "Press this key combination again once located in the destination table and on the destination field to create the relationship.",
	Say (msg228+msg154+getScriptKeyName("relAndJoinClearValues")+msg154a, OT_HELP)
	say (msg105+msg154+getScriptKeyName("deleteRelationship")+msg154a, OT_HELP) ; press control del to delete the selected relationship
elif QryDesignView then
	Say (msg242+msg154+GetScriptKeyName("CreateJoin")+msg154a, OT_HELP) ;
	Say (msg240, OT_HELP) ; press again to ...
	Say (msg228+msg154+getScriptKeyName("RelAndJoinClearValues")+msg154a, OT_HELP)
; wc118="oForm"
elif StringContains(realClassName,wc118) then
; check if in form design view
	if OAccess.Screen.activeForm.CurrentView==formDesignView then
		Say (msg181a+msg154+GetScriptKeyName("SelectToolboxControl")+msg154a, OT_HELP)
	endIf ; must be in form or datasheet view.
; read the form or subform hotkeys if any exist.
	HotKeyHelpDefaultLoop ()
; remaining form hotkeys are applicable regardless of the form view
	Say (msg155+msg154+GetScriptKeyName("ReadFormInControlOrder")+msg154a, OT_HELP)
	Say (msg156+msg154+GetScriptKeyName("SelectFormControl")+msg154a, OT_HELP)
	Say (msg167+msg154+GetScriptKeyName("ToggleLabelSearch")+msg154a, OT_HELP)
	endIf
say (msg161+msg154+GetScriptKeyName("sayStatusLine")+msg154a, OT_HELP)
Say (msg184+msg154+getScriptKeyName("SpeakDatabaseSummary")+msg154a, OT_HELP)
EndScript

Int Function BrailleBuildAcFocus ()
; added by JD 8 May 1998
; note does not handle optionGroups properly yet.
var
int Row,
int Col
let Col=getCursorCol()
let Row=GetCursorRow()
if OAccess.screen.activeForm() then
  if GlobalControl.ControlType==AcOptionGroup then
    BrailleAddString(GlobalOptionGroup,0,0,0)
    return true
  EndIf
  BrailleAddString(GlobalControlLabel,Col,Row,0)
  if GlobalControl.ControlType==acListBox then
; note had to use following line to get listbox selection
; because itemData property was returning an integer rather than the data.
    BrailleAddString(Globalcontrol.column(1,Globalcontrol.ListIndex),Col,Row,32)
  else
    BrailleAddFocusItem()
  endIf
  BrailleAddString(GlobalBrlCtlInfo,Col,Row,0)
  return true
elif stringContains(GetWindowClass(GetParent(globalFocusWindow)), wc117) then
  BrailleAddString(GlobalControl.name(),Col,Row,0)
  if GlobalControl.ControlType==acListBox then
    BrailleAddFocusLine()
  else
    BrailleAddFocusItem()
  endIf
  BrailleAddString(GetObjectType(),Col,Row,0)
  return true
endIf
return false
EndFunction

int Function BrailleBuildDialog (handle HWNDReal, string Buffer, string CheckedUnchecked)

 let hwndReal = GetRealWindow (GetFocus ())
 let Buffer = GetWindowName (hwndReal) ; title of the dialog box
if GetJcfOption (OPT_BRL_Verbosity)==0  then
 if (buffer != "") then ; there is a title
 ;msg509 = " dlg"
 BrailleAddString(buffer + msg509,0,0,0)
 endif
 let buffer = GetDialogPageName()
 if (buffer != "") then ; there is a page name
  ;msg510 = " page"
 BrailleAddString(buffer + msg510,0,0,0)
 endif
 let buffer = GetDialogStaticText()
 if (buffer != "") then ; there is static text in dialog
 BrailleAddString(buffer + " ",0,0,0)
 endif
 let buffer = GetGroupBoxName()
 if (buffer != "") then ; there is a GroupBox name
 ;msg511 = " gb"
 BrailleAddString(buffer + msg511,0,0,0)
 endif
 if ControlCanBeChecked () then
 if  (ControlIsChecked ()) then
 ;msg512 = "<x> "
 let CheckedUnchecked = msg512
 else
 ;msg513 = "< > "
 let CheckedUnchecked = msg513
 endif
 else
 let CheckedUnchecked = ""
 endif
 ;wc115 = "OArgDlg"
 if GetWindowClass(HwndReal)==wc115 then
    let buffer=globalControlLabel
 else
   let buffer = GetControlName()
 endIf
 if (buffer != "") &
 (GetWindowTypeCode(GetFocus()) == WT_RADIOBUTTON ||
 GetWindowTypeCode(GetFocus()) == WT_CHECKBOX) then
 BrailleAddString (CheckedUnchecked+buffer + " " +GetWindowType(GetFocus()),
GetCursorCol (), GetCursorRow (), 32)
 elif GetWindowTypeCode (GetFocus ()) ==WT_BUTTON
;msg514 = "Button"
then BrailleAddString (buffer+" "+msg514, GetCursorCol (), GetCursorRow (), 0)
Return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_EDIT ||
 GetWindowTypeCode(GetFocus()) == WT_COMBOBOX ||
 GetWindowTypeCode(GetFocus()) == WT_ListBOX ||
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||
 GetWindowTypeCode(GetFocus()) == WT_TREEVIEW)
then
BrailleAddString (buffer+" "+GetWindowType (GetFocus ()), 0, 0, 0)
 BrailleAddFocusItem()
  Return TRUE
 endif
; end beginer verbosity
elif  GetJcfOption (OPT_BRL_Verbosity)==1 then
 if (buffer != "") then ; there is a title
 ;msg515 = "_"
 BrailleAddString(buffer + msg515,0,0,0)
 endif
 let buffer = GetDialogPageName()
 if (buffer != "") then ; there is a page name
 ;msg515 = "_"
 BrailleAddString(buffer + msg515,0,0,0)
 endif
 let buffer = GetDialogStaticText()
 if (buffer != "") then ; there is static text in dialog
 BrailleAddString(buffer + " ",0,0,0)
 endif
 let buffer = GetGroupBoxName()
 if (buffer != "") then ; there is a GroupBox name
 ;msg515 = "_"
 BrailleAddString(buffer + msg515,0,0,0)
 endif
 if ControlCanBeChecked () then
 if  (ControlIsChecked ()) then
 ;msg512 = "<x> "
 let CheckedUnchecked = msg512
 else
 ;msg513 = "< > "
 let CheckedUnchecked = msg513
 endif
 else
 let CheckedUnchecked = ""
 endif
 let buffer = GetControlName()
 if (buffer != "") &
 (GetWindowTypeCode(GetFocus()) == WT_RADIOBUTTON ||
 GetWindowTypeCode(GetFocus()) == WT_CHECKBOX) then
 BrailleAddString (CheckedUnchecked+buffer + msg519,
GetCursorCol (), GetCursorRow (), 32)
 elif GetWindowTypeCode (GetFocus ()) ==WT_BUTTON
then BrailleAddString (buffer+msg519+msg514, GetCursorCol (), GetCursorRow (), 0)
Return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_EDIT ||
 GetWindowTypeCode(GetFocus()) == WT_COMBOBOX ||
 GetWindowTypeCode(GetFocus()) == WT_ListBOX ||
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||
 GetWindowTypeCode(GetFocus()) == WT_TREEVIEW)
then
BrailleAddString (buffer, 0, 0, 0)
 BrailleAddFocusItem()
  Return TRUE
 endif
; end intermediate verbosity
elif GetJcfOption (OPT_BRL_verbosity)==2  then
 if ControlCanBeChecked () then
 if  (ControlIsChecked ()) then
 ;msg512 = "<x> "
 let CheckedUnchecked = msg512
 else
 ;msg513 = "< > "
 let CheckedUnchecked = msg513
 endif
 else
 let CheckedUnchecked = ""
 endif
 let buffer = GetControlName()
 if (buffer != "") &
 (GetWindowTypeCode(GetFocus()) == WT_RADIOBUTTON ||
 GetWindowTypeCode(GetFocus()) == WT_CHECKBOX) then
 BrailleAddString (CheckedUnchecked+buffer + " " ,
GetCursorCol (), GetCursorRow (), 32)
 elif GetWindowTypeCode (GetFocus ()) ==WT_BUTTON
then BrailleAddString (buffer, GetCursorCol (), GetCursorRow (), 0)
Return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_EDIT ||
 GetWindowTypeCode(GetFocus()) == WT_COMBOBOX ||
 GetWindowTypeCode(GetFocus()) == WT_ListBOX ||
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||

 GetWindowTypeCode(GetFocus()) == WT_TREEVIEW)
then
BrailleAddString (GetControlName (), 0, 0, 0)
 BrailleAddFocusItem()
  Return TRUE
 endif
endif
EndFunction

int Function BrailleBuildLine ()
; Mod by JD 8 May 98 to track control focus
var
int PixelsPerSpace,
 handle hwndReal,
 string buffer,
 string CheckedUnchecked
 let PixelsPerSpace=GetJcfOption (	OPT_PIXELS_PER_SPACE)
SetJcfOption (	OPT_PIXELS_PER_SPACE, 99)
if MenusActive ()
then
BrailleBuildMenu()
Return TRUE
elif
DialogActive ()
Then
BrailleBuildDialog(HwndReal, buffer, checkedUnchecked)
return TRUE
elif
(GetWindowTypeCode (GetFocus())==WT_LISTVIEW ||
GetWindowTypeCode (GetFocus())==WT_LISTBOX ||
GetWindowTypeCode (GetFocus())==WT_TREEVIEW ||
GetWindowTypeCode (GetFocus())==WT_STARTBUTTON ||
GetWindowTypeCode (GetFocus())==WT_DESKTOP ||
GetWindowTypeCode (GetFocus())==WT_TASKBAR)
then BrailleBuildOther()
 Return TRUE
elif TableDesignView || (QryDesignView && InDesignGrid) ||
  GetWindowClass(GetParent(GetParent(GlobalFocusWindow)))==wc121 then
  BrailleAddString(GlobalControlLabel,GetCursorCol(),GetCursorRow(),0)
  BrailleAddFocusItem()
  BrailleAddString(GetObjectType(),GetCursorCol(),GetCursorRow(),0)
  return true
else
	return BrailleBuildAcFocus()
endIf
SetJcfOption (	OPT_PIXELS_PER_SPACE, PixelsPerSpace)
EndFunction

Script SayPriorCharacter ()
var
	int TheTypeCode
let FocusChangedCalled=false
let suppressColumnTitle=false ; possibly moving to a new column
PriorCharacter()
pause()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() && (not FocusChangedCalled) then
  	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say (Msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say (Msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endIf
; handle speaking of checkbox/radio button states on forms and subforms etc
sayActiveItem()
EndScript

Script sayNextCharacter() 
var
	int TheTypeCode

let FocusChangedCalled=false
let suppressColumnTitle=false ; possibly moving to a new column

NextCharacter()
pause()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() && (Not FocusChangedCalled) then
	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say (Msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say (Msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endIf
; handle speaking of checkbox/radio button states on forms and subforms etc
sayActiveItem()
EndScript

Script SayNextLine()
var
	int TheTypeCode
let FocusChangedCalled=false
let suppressRowTitle=false ; possibly moving to new row
NextLine()
pause()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if  not IsPCCursor () then
	SayLine ()
	return
EndIf
;wc110="OSysRel",
if GetWindowClass(GetParent(GetParent(GetParent(GetFocus()))))==wc110  then
	speakRelationship()
	return
endIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if CaretVisible () && (not FocusChangedCalled) then
	SayLine ()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if (TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) then
	SayLine()
endif
; handle speaking of checkbox/radio button states on forms and subforms etc
sayActiveItem()
EndScript

Script SayPriorLine ()
var
	int TheTypeCode
let FocusChangedCalled=false
let suppressRowTitle=false ; possibly moving to new row ; suppress echo except for list view
PriorLine()
pause()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor () then
	SayLine()
	return
endif
if GetWindowClass(GetParent(GetParent(GetParent(GetFocus()))))==wc110  then
	speakRelationship()
	return
endIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if CaretVisible() && (not FocusChangedCalled) then
	SayLine()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow ())
if (TheTypeCode == WT_TREEVIEW) ||
	(TheTypeCode == WT_MULTISELECT_LISTBOX) then
	SayLine()
EndIf
; handle speaking of checkbox/radio button states on forms and subforms etc
sayActiveItem()
EndScript

Void Function RefreshDatabases ()
oAccess.CurrentDb.tabledefs().refresh()
pause()
oAccess.CurrentDb.containers.refresh()
pause()
EndFunction

Script SpeakDatabaseSummary ()
var
object db,
object Doc,
object container,
int ContainerIndex,
int ContainerCount,
int docCount,
int DocIndex,
int UserObjects,
string tmpStr ; used for saystrings to avoid multiple lines in speechbox mode

if !oAccess.currentDb() then
  Say (msg204, OT_MESSAGE) ; No database information available.
  return
endIf
RefreshDatabases()
let db=oAccess.currentDb()
let tmpStr=db.name()
Say (msg200+tmpStr, OT_TEXT)
let ContainerCount=db.containers.count()
let ContainerIndex=1 ; skip the databases container
while ContainerIndex < ContainerCount
  let Container=db.containers(ContainerIndex)
  if not StringContains(IgnoredContainers,container.name()) then
    let DocCount=container.documents.count()
    if DocCount > 0 then
      let DocIndex=0
      let UserObjects=0 ; only count user defined objects
      while DocIndex < DocCount
        let doc=container.documents(DocIndex)
  ; only want to speak and count user defined objects
;msg516 = "engine"
        if doc.owner !=msg516 &&
          (not StringContains(doc.name(), msg520) && not StringContains(doc.name,msg521)) then
        let UserObjects=UserObjects+1
; only want to say container name if at least one user object
; this cannot be predetermined.
        if userObjects==1 then
          let tmpStr=container.name()
          Say (msg201+tmpStr+msg202, OT_MESSAGE) ; the (containers) defined
        endif

          Say (Doc.name(), OT_TEXT)
        pause()
        EndIf
        let DocIndex=DocIndex+1
      EndWhile
      if userObjects > 0 then
        Say (IntToString(UserObjects)+msg203, OT_STRING) ; x in total
      endIf
    EndIf
  endIf
  let ContainerIndex=ContainerIndex+1
endWhile
; now speak table and query summary
let DocCount=db.TableDefs.count()
let docIndex=0
let userObjects=0
while docIndex < DocCount
  let doc=db.tableDefs(docIndex)
  if doc.owner !=msg516 &&
    (not StringContains(doc.name(), msg520) && not StringContains(doc.name,msg521)) then
    let UserObjects=UserObjects+1
; only want to say table name if at least one user object
; this cannot be predetermined.

    if UserObjects==1 then
      Say (msg201+msg201a+msg202, OT_MESSAGE) ; the tables defined are
    endIf
    Say (Doc.name(), OT_TEXT)
    pause()
  EndIf
    let DocIndex=DocIndex+1
endWhile
if userObjects > 0 then
  say (IntToString(UserObjects)+msg203, OT_STRING) ; x in total
endIf
let DocIndex=0
let docCount=db.QueryDefs.count()
let userObjects=0
while docIndex < DocCount
  let doc=db.queryDefs(docIndex)
  if doc.owner !=msg516 &&
    (not StringContains(doc.name(), msg520) && not StringContains(doc.name,msg521)) then
    let UserObjects=UserObjects+1
; only want to say query name if at least one user object
; this cannot be predetermined.
    if UserObjects==1 then
      Say (msg201+msg201b+msg202, OT_MESSAGE) ; the queries defined are
    endIf
    Say (Doc.name(), OT_TEXT)
    pause()
  EndIf
    let DocIndex=DocIndex+1
endWhile
if userObjects > 0 then
  say (IntToString(UserObjects)+msg203, OT_STRING) ; x in total
endIf
EndScript

String Function GetFieldType (int Type)
if type==dbBigInt then
  return txtDbBigInt ; =16, ; "Big integer",
elif type==DbBinary then
  return txtDbBinary ; =9, ; "Binary",
elif type==DbBoolean then
  return txtDbBoolean ; =1, ; "Boolean",
elif type==dbByte then
  return txtDbByte ; =2, ; "Byte",
elif type==dbChar then
  return TxtDbChar ; =18, ; "Char",
elif type==dbCurrency then
  return txtDbCurrency ; =5, ; "Currency",
elif type==dbDate then
  return TxtDbDate ; =8, ; "Date/Time",
elif type==dbDecimal then
  return TxtDbDecimal ; =20, ; "Decimal",
elif type==dbDouble then
  return txtDbDouble ; =7, ; "Double",
elif type==dbFloat then
  return TxtDbFloat ; =21, ; "Float",
elif type==dbGid then
  return txtDbGid ; =15, ; "Gid",
elif type==dbInteger then
  return txtDbInteger ; =3, ; "integer",
elif type==dbLong then
  return txtDbLong ; =4, ; "Long",
elif type==dbLongBinary then
  return txtDbLongBinary ; =11, ; "Long Binary",
elif type==dbMemo then
  return txtDbMemo ; =12, ; "Memo",
elif type==dbNumeric then
  return txtDbNumeric ; =19, ; "Numeric",
elif type==dbSingle then
  return txtDbSingle ; =6, ; "Single",
elif type==dbText then
  return txtDbText ; =10, ; "Text",
elif type==dbTime then
  return txtDbTime ; =22, ; "Time",
elif type==dbTimeStamp then
  return txtDbTimeStamp ; =23, ; "Time Stamp",
elif type==dbVarBinary then
  return txtDbVarBinary ; =17, ; "Var Binary",
elif type==dbAutoNumber then
  return txtDbAutoNumber ; ="Auto number"
else
  return txtdbUnknown
endIf
EndFunction

Void Function SpeakFieldInfo ()
var
object db,
object table,
object fields,
string TableName,
string FieldSize,
string FieldName,
string TmpStr ; used for temp storage of name to speak
; wc120="OTable"
if GetWindowClass(GetRealWindow(GetFocus()))!=wc120 then
  Say (msg208, OT_MESSAGE) ; no table information available
  return
endIf
if !oAccess.currentDb() then
  Say (msg204, OT_MESSAGE) ; No database information available.
  return
endIf
refreshDatabases()
let TableName=OAccess.screen.activeControl.parent.name()
let db=oAccess.currentDb()
let table=Db.tableDefs(TableName)
let fields=table.fields()
if fields.Count()==0 then
  say (msg208, OT_MESSAGE) ; no table info available
  return
endIf
let TableName=OAccess.screen.activeControl.parent.name()
let FieldName=OAccess.screen.activeControl.name()
if fields(FieldName).name !="" then
  let tmpStr=fields(fieldName).name()
else
  let TmpStr=TableName+msg205a ; ID
EndIf
if fields(fieldName).size() > 0 then
	let fieldSize=IntToString(fields(fieldName).size())+msg212
else
	let fieldSize=msg207a ; dynamic ;(memo fields etc.
endIf
if GetVerbosity()==beginner then
  Say (msg210+tmpStr+msg210a, OT_MESSAGE) ; this is the x field in the y table
	Say (msg210b+msg206+msg210c+GetFieldType(fields(fieldName).type()), OT_STRING) ; the data type:
	Say (msg210b+msg207+msg210c+fieldSize, OT_STRING) ; The size is: x characters
	Say (msg210b+msg213+msg210c+intToString(fields(FieldName).ordinalPosition()), OT_STRING) ; the ordinal position is:
	say (msg214+intToString(fields.count())+msg215, OT_MESSAGE) ; there are x fields.
elif getVerbosity()==intermediate then
	Say (msg205+tmpStr, OT_CONTROL_NAME) ; field name:
	Say (msg206+GetFieldType(fields(fieldName).type()), OT_STRING) ; data type:
	Say (msg207+fieldSize, OT_STRING) ; The size is: x characters
	Say (msg213+intToString(fields(FieldName).ordinalPosition()), OT_STRING) ; the ordinal position is:
	say (intToString(fields.count())+msg215, OT_MESSAGE) ; x fields.
else
	Say (tmpStr, OT_CONTROL_NAME) ; field name:
	Say (GetFieldType(fields(fieldName).type()), OT_STRING) ; data type:
	Say (fieldSize, OT_STRING) ; The size is: x characters
	Say (intToString(fields(FieldName).ordinalPosition())+msg492+intToString(fields.count()), OT_MESSAGE) ; x of y
endIf
if fields(FieldName).required then
  let TmpStr=msg217
else
  let tmpStr=msg218 ; optional
endIf
if GetVerbosity()==beginner then
  Say (msg216+tmpStr, OT_MESSAGE) ; data in this field is
elif getVerbosity()==intermediate then
  Say (msg216a+tmpStr, OT_MESSAGE) ; data is
else
	say(tmpStr,ot_help)
endIf
EndFunction

Script SpeakTableSummary ()
var
object db,
object table,
object fields,
string TableName,
string tmpStr, ; used in saystrings to avoid multiple lines in speechbox mode
int FieldCount,
int FieldIndex
; wc120="OTable"
if GetWindowClass(GetRealWindow(GetFocus()))!=wc120 then
  Say (msg208, OT_MESSAGE) ; no table information available
  return
endIf
if !oAccess.CurrentDb() then
  Say (msg204, OT_MESSAGE) ; No database information available.
  return
endIf
refreshDatabases()
let TableName=OAccess.screen.activeControl.parent.name()
let db=OAccess.currentDb()
let table=db.tabledefs(TableName)
let fields=table.fields()
fields.refresh()
pause()
if fields.Count()==0 then
  say (msg208, OT_MESSAGE) ; no table info available
  return
endIf
let tmpStr=table.name()
Say (tmpStr+msg209+intToString(fields.count())+msg215, OT_STRING) ; table x has y fields.
let fieldcount=fields.count()
let fieldIndex=0
while fieldIndex < FieldCount
  if fields(FieldIndex).name !="" then
    let tmpStr=fields(fieldIndex).name()
  else
    let tmpStr=TableName+msg205a ; ID
  EndIf
  Say (msg205+tmpStr, OT_CONTROL_NAME) ; Field name:
  say (msg206+GetFieldType(fields(fieldIndex).type()), OT_STRING) ; type: xx
  say (msg207+intToString(fields(fieldIndex).size()), OT_STRING) ; size: xx
  pause()
let fieldIndex=FieldIndex+1
endWhile
EndScript

String Function GetSectionName (int Section)
if section==AcDetail then
  return txtAcDetail
elif section==AcHeader then
  return txtAcHeader
elif section==AcFooter then
  return txtAcFooter
elif section==AcPageHeader then
  return txtAcPageHeader
elif section==AcPageFooter then
  return txtAcPageFooter
elif section==AcGroupLevel1Header then
  return TxtAcGrpLvl1hdr
elif section==AcGroupLevel2Header then
  return txtAcGrpLvl2Hdr
elif section==AcGroupLevel1Footer then
  return txtAcGrpLvl1Ftr
elif section==AcGroupLevel2Footer then
  return txtAcGrpLvl2Ftr
endIf
EndFunction

Int Function GetSection ()
var
string field,
string class
SaveCursor()
invisibleCursor()
MoveToWindow(GetRealWindow(GetFocus()))
FindFirstAttribute (attrib_highlight)
let class=getWindowClass(GetCurrentWindow())
while (class!=wc118a) && FindNextAttribute (attrib_highlight)
  let class=GetWindowClass(GetCurrentWindow())
endWhile
let field=GetField()
restoreCursor()
if field==txtAcDetail then
  return acDetail
elif field==txtAcHeader then
  return acHeader
elif field==txtAcFooter then
  return acFooter
elif field==txtAcPageHeader then
  return AcPageHeader
elif field==txtAcPageFooter then
  return acPageFooter
elif field==TxtAcGrpLvl1Hdr then
  return acGroupLevel1header
elif field==TxtAcGrpLvl2Hdr then
  return acGroupLevel2Header
elif field==TxtAcGrpLvl1Ftr then
  return AcGroupLevel1Footer
elif field==TxtAcGrpLvl2Ftr then
  return acGroupLevel2Footer
endIf
EndFunction

string Function GetParentName (int HostType)
var
object form,
object control,
int index,
int selectedControlIndex,
int count,
string CtlList,
string CtlName,
string ParentName
let parentName=""

if hostType==acForm then
  let form=oAccess.screen.activeForm()
elif hostType==acReport then
  let form=oAccess.screen.activeReport()
else
  return parentName
endIf
let count=form.controls.count()
if count ==0 then
  return parentName
endIf
let index=0
while Index < count
let control=form.controls(index)
  let CtlName=control.name()
  let CtlList=ctlList+CtlName+msg517
  let index=index+1
   EndWhile
let CtlList=CtlList+NoParentOption
if GetVerbosity()==beginner then
  Say (msg111, OT_MESSAGE) ; Select No Parent if you do not want to select a parent control
endIf
let SelectedControlIndex=0
; avoid dlg appearing and disappearing without allowing selection
while not selectedControlIndex
  pause()
  let SelectedControlIndex=DlgSelectItemInList (CtlList, msg118, false)
EndWhile
; check exit condition: NoParentOption selected
if SelectedControlIndex==(count+1) then
  return parentName
endIf
if SelectedControlIndex then
  let ParentName= form.controls(SelectedControlIndex-1).name()
endIf
return parentName
EndFunction

Script SelectToolboxControl ()
var
int HostType, ; set to acForm or AcReport
int index,
string formName,
object host, ; either form or report
int ControlType,
int section,
string parent, ; parent's name
int OldCtlCount,
string tools
let Tools=TxtAcLabel+msg517+TxtAcRectangle+msg517+TxtAcLine+msg517+TxtAcImage+msg517+
TxtAcCommandButton+msg517+TxtAcOptionButton+msg517+TxtAcCheckBox+msg517+TxtAcOptionGroup+msg517+
TxtAcBoundObjectFrame+msg517+TxtAcTextBox+msg517+TxtAcListBox+msg517+TxtAcComboBox+msg517+
TxtAcSubform+msg517+TxtAcObjectFrame+msg517+TxtAcPageBreak+msg517+TxtAcPage+msg517+
TxtAcCustomControl+msg517+TxtAcToggleButton+msg517+TxtAcTabCtl+msg517
if not isDesignView() then
  Say (msg221, OT_MESSAGE) ; not in report or form design view
  return
endIf
if OAccess.screen.activeReport() then
  let hostType=acReport
  let host=oAccess.screen.activeReport()
elif GetWindowClass(globalFocusWindow)==wc118 && OAccess.screen.activeForm.currentView==0 then
  let hostType=acForm
  let host=oAccess.screen.activeForm()
else
  Say (msg221, OT_MESSAGE) ; not in report or form design view
  return
endIf
let index=DlgSelectItemInList (Tools, msg220, false)
if index==1 then
  let ControlType=acLabel
elif index==2 then
  let ControlType=acRectangle
elif index==3 then
  let ControlType=acLine
elif index==4 then
  let ControlType=acImage
elif index==5 then
  let ControlType=acCommandButton
elif index==6 then
  let ControlType=acOptionButton
elif index==7 then
  let controlType=acCheckBox
elif index==8 then
  let ControlType=acOptionGroup
elif index==9 then
  let ControlType=acBoundObjectFrame
elif index==10 then
  let ControlType=acTextBox
elif index==11 then
  let ControlType=acListBox
elif index==12 then
  let controlType=acComboBox
elif index==13 then
  let ControlType=acSubform
elif index==14 then
let ControlType=acObjectFrame
elif index==15 then
let controlType=acPageBreak
elif index==16 then
  let ControlType=acPage
elif index==17 then
  let controlType=acCustomControl
elif index==18 then
  let controlType=acToggleButton
elif index==19 then
  let controlType=acTabCtl
endIf
if ControlType then
; get section to place control in
  let section=GetSection()
  if controlType==acLabel ||
     ControlType==acCheckbox ||
     ControlType==acOptionButton ||
     ControlType==acToggleButton then
  let parent=GetParentName(hostType)
  else
    let parent=""
  endIf
  let FormName=host.name()
  pause() ; give computer time to refocus on Access from Listbox DLG
  if HostType==acForm then
    let OldCtlCount=oAccess.screen.ActiveForm.controls.count()
    OAccess.CreateControl(formname, controlType, section, parent)
    Pause()
    if oAccess.screen.activeForm.controls.count() == oldCtlCount then
      Say (msg223a, OT_MESSAGE) ; no control created
      return
    endIf
  elif hostType==acReport then
    let oldCtlCount=oAccess.screen.activeReport.controls.count()
    OAccess.CreateReportControl(formname, controltype, section, parent)
    pause()
    if oAccess.screen.activeReport.controls.count() == oldCtlCount then
      Say (msg223a, OT_MESSAGE) ; no control created
      return
    endIf
  endIf
  if GetVerbosity()==beginner then
      Say (host.controls(host.controls.count()-1).name(), OT_MESSAGE)
      Say (msg223, OT_MESSAGE) ; control created in section
      Say (GetSectionName(host.controls(host.controls.count()-1).section()), OT_MESSAGE)
  endIf
endIf
EndScript

Script CreateJoin ()
var
string destField,
int destCol,
int DestRow,
handle OldFocus

if QryDesignView && not InDesignGrid then
  if JoinInit then
  let destField=getChunk()
    Say (msg239+SourceField+msg231+destField, OT_STATUS) ;  creating join between source and dest
    let destCol=GetCursorCol()
    let DestRow=GetCursorRow()
    DragItemWithMouse (sourceCol, sourceRow, destCol, destRow)
  let JoinInit=false
  else
        let SourceField=GetChunk()
    let SourceCol=GetCursorCol()
    let SourceRow=GetCursorRow()
    say (msg240, OT_MESSAGE) ;  press key combination again to create join")
    say (msg154, OT_MESSAGE) ; use
    say (GetScriptKeyName("RelAndJoinClearValues"), OT_MESSAGE)
    Say (msg228, OT_MESSAGE) ; to clear
    let JoinInit=true
  endIf
else
  say (msg241, OT_MESSAGE) ;  not in query design View field lists.
endIf
EndScript

Script CreateRelationship ()
var
string DestTableName,
string DestField,
int DestCol,
int DestRow

; wc110="OSysRel"
if GetWindowClass(GetParent(GetParent(GetParent(GetFocus())))) !=wc110 then
  Say (msg232, OT_MESSAGE) ; not in relationships dialog
  return
endIf
if not RelInit then
  let SourceTableName=GetWindowName(GetRealWindow(GetFocus()))
  let SourceField=GetWindowText(getFocus(), true)
  let SourceCol=GetCursorCol()
  let SourceRow=GetCursorRow()
  Say (msg225+sourceTableName, OT_STATUS) ;"Setting source Table to") ; setting source table to xxx
  say (msg226+SourceField, OT_STATUS) ; and source field to yyy
  Say (msg227, OT_MESSAGE) ; "Press this key combination again once located in the destination table and on the destination field to create the relationship."
  Say (msg154, OT_MESSAGE) ; use
  say (GetScriptKeyName("RelAndJoinClearValues"), OT_MESSAGE)
  say (msg228, OT_MESSAGE) ; to cancel the relationship initialisation
  let relInit=true
else
  let DestField=GetWindowText(getFocus(), true)
  let DestTableName=GetWindowName(GetRealWindow(GetFocus()))
  Say (msg229+sourceField+msg230+
  sourceTableName+msg231+destField+msg230+destTableName, OT_STATUS) ;
  let DestCol=GetCursorCol()
  let DestRow=getCursorRow()
  DragItemWithMouse (sourceCol, sourceRow, destCol, destRow)
  let RelInit=false
endIf
EndScript

Script RelAndJoinClearValues ()
if GetWindowClass(GetParent(GetParent(GetParent(GetFocus()))))==wc110  || QryDesignView then
  Say (msg224, OT_STATUS) ; "canceling relationship or Join initialisation.")
  let relInit=false
  let JoinInit=false
endIf
EndScript

Void Function SpeakRelationship ()
var
int RelFound,
object db,
object relations,
object rel,
object fields,
int fieldCount,
int fieldIndex,
int count,
int index,
string tmpStr,
string TableName,
string FieldName

if !OAccess.currentDb() then
	Say (msg232, OT_MESSAGE) ; "Not on relationships screen."
	return
EndIf
; wc110="OSysRel" 
if GetWindowClass(GetParent(GetParent(GetParent(GetFocus())))) !=wc110  then
	return
endIf
let db=OAccess.currentDb()
let relations=db.relations()
let count=relations.count()
let index=0
; getChunk and GetLine fail on some video cards on the first item in a listbox. 
; which is why I am using getWindowText
let FieldName=GetWindowText (GetFocus(), true)
let TableName=GetWindowName(GetRealWindow(GetFocus()))
while index < count
	let RelFound=false
	let rel=relations(index)
	if tableName==rel.table() then
		let fieldCount=rel.fields.count()
		let fieldIndex=0
		while fieldIndex < fieldCount
			if rel.fields(FieldIndex).name==FieldName then
				let relFound=true
				let FieldIndex=FieldCount
			endIf
			let FieldIndex=FieldIndex+1
		endWhile
		if relFound then
			let TmpStr=rel.foreignTable
			if GetVerbosity()==beginner then
				SayUsingVoice(vctx_message, fieldName+msg230, OT_CONTROL_NAME) ; field name in table
				sayUsingVoice (vctx_message, tablename+msg233+msg230a+tmpStr, OT_STATUS) ; x is referenced by
			else
				sayUsingVoice (vctx_message,fieldName+msg233+tmpStr, OT_STRING) ; field is referenced by table
			endIf
		endIf
	elif TableName==rel.foreignTable() then
		let fieldCount=rel.fields.count()
		let fieldIndex=0
		while fieldIndex < fieldCount
			if rel.fields(FieldIndex).foreignName==FieldName then
				let relFound=true
				let FieldIndex=FieldCount
			endIf
			let FieldIndex=FieldIndex+1
		endWhile
		if relFound then
			let tmpstr=rel.Table
			if GetVerbosity()==beginner then
				SayUsingVoice (vctx_message, fieldName+msg230, OT_CONTROL_NAME) ; field name in table
				SayUsingVoice (vctx_message,tablename+msg234+msg230a+tmpStr, OT_STATUS) ; x references y
			else
				sayUsingVoice (vctx_message, fieldName+msg234+tmpStr, OT_MESSAGE) ; fieldname references table
			endIf
		endIf
	endIf
	let index=index+1
endWhile
EndFunction

Script deleteRelationship ()
var
int RelFound,
object db,
object relations,
object rel,
object fields,
int fieldCount,
int fieldIndex,
int count,
int index,
string tableName,
string fieldName,
string relName
if !OAccess.currentDb() then
	return
EndIf
if GetWindowClass(GetParent(GetParent(GetParent(GetFocus()))))==wc110  then
  let db=OAccess.currentDb()
  let relations=db.relations()
let count=relations.count()
let index=0
  let FieldName=GetWindowText(GetFocus(), true)
  saveCursor()
  invisibleCursor()
  moveToWindow(GetParent(GetFocus()))
  let TableName=GetChunk()
  restoreCursor()
while index < count
  let RelFound=false
  let rel=relations(index)
  if tableName==rel.table() then
    let fieldCount=rel.fields.count()
    let fieldIndex=0
    while fieldIndex < fieldCount
      if rel.fields(FieldIndex).name==FieldName then
        let relFound=true
        let FieldIndex=FieldCount
      endIf
      let FieldIndex=FieldIndex+1
    endWhile
    if relFound then
      let relName=rel.name
      say (msg106+relName, OT_STATUS) ; deleting relationship
      relations.delete(relName)
      return
    endIf
  elif TableName==rel.foreignTable() then
    let fieldCount=rel.fields.count()
    let fieldIndex=0
    while fieldIndex < fieldCount
      if rel.fields(FieldIndex).foreignName==FieldName then
        let relFound=true
        let FieldIndex=FieldCount
      endIf
      let FieldIndex=FieldIndex+1
    endWhile
    if relFound then
      let relName=rel.Name()
      say (msg106+relName, OT_MESSAGE) ; deleting relationship
      relations.delete(relName)
      return
    endIf
  endIf
  let index=index+1
endWhile
else
; not in relationships screen, just do the normal keystroke
	{control+delete}
endIf
EndScript

Function AutoFinishEvent ()
var
	object null
let oAccess = null
let GlobalControl=null
EndFunction

Script CloseOfficeAssistant ()
var
handle hWnd,
object OfficeAssistant,
object menubar
; Access 2000
let menubar=msoGetMenubarObject()
let officeAssistant=oAccess.assistant
;note if we could set object properties then it would be a simple matter to set the visible property of the assistant object 
;to false to hide the assistant.
if !officeAssistant.visible then
	say(msg471,ot_string)
	return
endIf
speechOff()
if Menubar.controls(mnuHelp).controls(mnuHelpHideAssistant) then
	{alt+h} ; help
	pause()
	{o} ; toggle Office Assistant to off.
	pause()
else
; no menu item to turn off the assistant, we'll try find it manually.
; This is only applicable to Access 97.
	SaveCursor()
	JAWSCursor()
	let hWnd = FindTopLevelWindow ("MSOAssistant", "")
	if (hWnd && IsWindowVisible (hWnd)) then
		MoveToWindow(hWnd)
		RightMouseButton ()
		pause()
		{h}
		pause()
		RestoreCursor()
	endIf
	delay(10)
endIf
speechOn()
; Test to see if we closed it.
if officeAssistant.visible then
	say(msg474,ot_status)
else
	say(msg473,ot_status)
endIf
EndScript

Script OpenListBox ()
var
int TheTypeCode

; wc116=okttbx can be an edit combo, don't want to read next sentence here
let theTypeCode=getWindowTypeCode(GetFocus())
if GetWindowClass(GetFocus())==wc116 || theTypeCode==wt_combobox || theTypeCode==wt_editcombo then
	{Alt+Down Arrow}
	Say (msg48, OT_MESSAGE) ;"Open List Box"
else
		PerformScript SayNextSentence()
endIf
EndScript

Script CloseListBox ()
var
	int TheTypeCode
; wc116=okttbx can be an edit combo, don't want to read next sentence here
let theTypeCode=getWindowTypeCode(GetFocus())
if GetWindowClass(GetFocus())==wc116 || theTypeCode==wt_combobox || theTypeCode==wt_editcombo then
	{Alt+up Arrow}
	Say (msg49, OT_MESSAGE) ;"Close List Box"
else
		PerformScript SayPriorSentence()
endIf
EndScript

Script sayWord ()
; wc114="OFormChild"
if GetWindowClass(GetFocus())==wc114 then
	SayActiveItem()
else
	performScript sayWord() ; default
endIf
EndScript

Script sayLine ()
; wc114="OFormChild"
if GetWindowClass(GetFocus())==wc114 then
	SayActiveItem()
else
	performScript sayLine() ; default
endIf
if GetWindowClass(GetParent(GetParent(GetParent(GetFocus()))))==wc110  then
	speakRelationship()
	return
endIf
EndScript

Script sayCharacter ()
; wc14="OFormChild"
if GetWindowClass(GetFocus())==wc114 then
	SayActiveItem()
else
	performScript sayCharacter() ; default
endIf
EndScript

Script ReadBoxInTabOrder()
var
object form

let form=OAccess.screen.activeForm()
if DialogActive () then
	performScript readBoxInTabOrder() ; default
elif form then
	performScript readFormInControlOrder()
else
	performScript readBoxInTabOrder() ; default
endIf
endScript

Void Function Unknown (string TheName, int IsScript)
; ignore  
say(theName+msg4,ot_help)
EndFunction

Void Function ActiveItemChangedEvent (handle curHwnd, int curObjectId, int curChildId, handle prevHwnd, int prevObjectId, int prevChildId)
; need to override here otherwise get the word toolbar being spoken each time you move from toolbar button to toolbar button
if GetWindowClass(curHwnd)==wc107 then
; on Access 2000 toolbar
	sayLine()
	return
endIf
SaveCursor ()
PCCursor ()
SayObjectActiveItem()
RestoreCursor ()
EndFunction
